﻿-- =============================================
-- Then we gotta update correspondent stored procedures Sp_UpdateRespondentResponse used by DTS Export
-- Sp_UpdateRespondentResponse now uses MERGE for SQL 2008 and above (US1682 May 2013)
-- US1685 - RHL - November 2013
--
-- Sept 2016 :  We bring back UpSert technic bevcause of Merge performance issue DE13721
-- sp_UpdateRespondentResponse uses a SQL merge statement instead of an upsert which has an impact on intweb performances
-- =============================================
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_UpdateRespondentResponse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
GO

CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
	@ProjectId     INT,
	@UserId        INT,
	@CollectMode   INT,
	@RpsRespondent VARCHAR(10),
	@RpsQuestion   VARCHAR(32),
	@RpsMatrix     BIGINT,
	@RpsMention    INT,
	@RpsContent    NVARCHAR(100),
	@rpsOpened     NTEXT,
	@rpsType       INT,
	@CallId        INT,
	@Source        nvarchar(max),
	@Modified      datetime = null,
	@QuestionOrder INT = null,
	@ChoiceOrder   INT = null
AS
	IF @Modified is null SET @Modified = GETUTCDATE();
	UPDATE Response
	SET    ProjectId = @ProjectId,
			CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
			modifiedby = @UserId,
			modified = @Modified,
			RpsContent = @RpsContent,
			RpsOpened = @RpsOpened,
			CallId = @CallId,
			[Source] = @Source,
			QuestionOrder = @QuestionOrder,
			ChoiceOrder = @ChoiceOrder
	WHERE  RpsRespondent = @RpsRespondent
			AND RpsQuestion = @RpsQuestion
			AND RpsMatrix = @RpsMatrix
			AND RpsMention = @RpsMention
			AND RpsType = @RpsType
	IF @@ROWCOUNT = 0
	BEGIN
	INSERT INTO Response
	(RpsRespondent,
		ProjectId,
		CollectMode,
		modifiedby,
		modified,
		RpsQuestion,
		RpsMatrix,
		RpsMention,
		RpsContent,
		RpsOpened,
		RpsType,
		CallId,
		[Source],
		QuestionOrder,
		ChoiceOrder)
	VALUES    (@RpsRespondent,
		@ProjectId,
		@CollectMode,
		@UserId,
		@Modified,
		@RpsQuestion,
		@RpsMatrix,
		@RpsMention,
		@RpsContent,
		@rpsOpened,
		@rpsType,
		@CallId,
		@Source,
		@QuestionOrder,
		@ChoiceOrder)
	END
GO

